/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.Trace;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import org.snia.wbem.cim.CIMException;
import org.snia.wbemcfg.GlobalConfig;

public class ProviderLceCommunication {
    private static Hashtable socketLockTable = new Hashtable();

    private ProviderLceCommunication() {
    }

    public static boolean isRegistered(String string) {
        return socketLockTable.containsKey(string);
    }

    public static synchronized void registerConnection(String string) throws CIMException {
        Object object;
        Trace.trace("apulhscT", " -> ProviderLceCommunication- registerConnection");
        if (socketLockTable.containsKey(string)) {
            System.out.println("138E");
        }
        String string2 = new String();
        try {
            object = InetAddress.getLocalHost();
            System.out.println("the local host is :" + object);
            string2 = ((InetAddress)object).getHostName();
            System.out.println("the hostname is :" + string2);
        }
        catch (Exception exception) {
            Trace.trace("apulhscT", " <- ProviderLceCommunication- registerConnection");
            HSCLogUtils.serverLog(exception, HSCLogUtils._HSCClassLogInfo);
            throw new CIMException("138F");
        }
        try {
            object = new HscProviderSocket(string2, 9734, string);
            socketLockTable.put(string, object);
        }
        catch (Exception exception) {
            HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
            Trace.trace("apulhscT", " <- ProviderLceCommunication- registerConnection");
            throw new HSCCIMException(exception);
        }
        Trace.trace("apulhscT", " <- ProviderLceCommunication- registerConnection");
    }

    public static synchronized HscProviderSocket obtainSocket(String string) throws CIMException {
        boolean bl = true;
        boolean bl2 = true;
        HscProviderSocket hscProviderSocket = null;
        Trace.trace("apulhscT", " -> ProviderLceCommunication-obtainSocket");
        if (GlobalConfig.debugLevel((int)8) > 0) {
            System.out.println("Thread " + Thread.currentThread().getName() + " try to obtain lock" + string);
        }
        Trace.trace("apulhscD", "Thread try to obtain lock", Thread.currentThread().getName());
        hscProviderSocket = (HscProviderSocket)socketLockTable.get(string);
        if (hscProviderSocket == null) {
            throw new CIMException("1391");
        }
        bl2 = hscProviderSocket.lock();
        if (!bl2) {
            System.out.println("failed to obtain lock: " + string);
            throw new CIMException("138A");
        }
        Trace.trace("apulhscT", " <- ProviderLceCommunication-obtainSocket ");
        return hscProviderSocket;
    }

    public static synchronized void deleteSocket(String string) throws CIMException {
        HscProviderSocket hscProviderSocket = null;
        Trace.trace("apulhscT", " ->  ProviderLceCommunication-deleteSocket");
        hscProviderSocket = (HscProviderSocket)socketLockTable.get(string);
        if (hscProviderSocket == null) {
            throw new CIMException("1391");
        }
        socketLockTable.remove(string);
        try {
            hscProviderSocket.closeSocket();
        }
        catch (Exception exception) {
            HSCLogUtils.serverLog(exception, HSCLogUtils._HSCClassLogInfo);
        }
        Trace.trace("apulhscT", " <-  ProviderLceCommunication-deleteSocket");
    }

    public static void setCspConnectionFlag(String string, boolean bl) {
        System.out.println("start setCspConnectionFlag: " + bl + " cecName=" + string);
        HscProviderSocket hscProviderSocket = (HscProviderSocket)socketLockTable.get(string);
        if (hscProviderSocket != null) {
            hscProviderSocket.setCspConnectionFlag(bl);
        }
        System.out.println("end of setCspConnectionFlag");
    }

    public static void dump() {
        Enumeration enumeration = socketLockTable.keys();
        System.out.println("");
        System.out.println("********** Dump Provider Socket Locks ***************");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            HscProviderSocket hscProviderSocket = (HscProviderSocket)socketLockTable.get(string);
            Thread thread = null;
            if (hscProviderSocket != null) {
                thread = hscProviderSocket.getLockingThread();
            }
            if (thread != null) {
                System.out.println("cecName: " + string + " thread-" + thread.getName());
                continue;
            }
            System.out.println("cecName: " + string + " thread-NULL");
        }
        System.out.println("**********End Dump Provider Socket Locks ***************");
    }

    static {
        if (GlobalConfig.debugLevel((int)8) > 0) {
            System.out.println("static block being executed");
        }
        Trace.trace("apcshscD", " ProviderLceCommunication - static block being executed");
    }
}

